<schema xmlns="http://purl.oclc.org/dsdl/schematron">
	<ns uri="http://www.schematron.info/arche" prefix="arc"/>
	<phase id="alles">
		<active pattern="arche"/>
		<active pattern="noah"/>
	</phase>
	<phase id="unterkunft">
		<active pattern="arche"/>
	</phase>
	<phase id="paare">
		<active pattern="noah"/>
	</phase>
	<pattern id="arche">
		<rule context="arc:zimmer[arc:tier[@fleischfresser='nein']]">
			<report test="arc:tier[@fleischfresser='ja']">Es gibt Fleischfresser und Pflanzenfresser in einer Unterkunft. Die Tiere sind keine Nahrungsquelle!</report>
		</rule>
	</pattern>
	<pattern id="noah">
		<rule context="arc:tier">
			<let name="tierart" value="arc:art"/>
			<report test="count(parent::*/arc:tier[arc:art=$tierart])>2">In dieser Unterkunft gibt es mehr als zwei Tiere dieser Art (<value-of select="arc:art"/>).</report>
			<assert test="not(count(parent::*/arc:tier[arc:art=$tierart])&lt;2)">In dieser Unterkunft gibt kein Paar dieser Art (<value-of select="arc:art"/>).</assert>
		</rule>
	</pattern>
</schema>