<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron">
	<title>Schematron für Noah</title>
	<p>Dieses Schematron soll Noah helfen, die richtigen Tiere in der adäquaten Umgebung unterzubringen.</p>
	<ns uri="http://www.schematron.info/arche" prefix="arc"/>
	<phase id="alles">
		<active pattern="arche"/>
		<active pattern="noah"/>
	</phase>
	<pattern id="arche">
		<rule context="arc:zimmer[arc:tier[@fleischfresser='nein']]">
			<report test="arc:tier[@fleischfresser='ja']">Es gibt Fleischfresser und Pflanzenfresser in einer Unterkunft. Die Tiere sind keine Nahrungsquelle!</report>
		</rule>
	</pattern>
	<pattern id="noah">
		<rule context="arc:tier">
			<let name="tierart" value="arc:art"/>
			<report test="count(parent::*/arc:tier[arc:art=$tierart])>2"
				diagnostics="Anzahl">In dieser Unterkunft gibt es mehr als zwei Tiere dieser Art (<value-of select="arc:art"/>).</report>
			<assert test="not(count(parent::*/arc:tier[arc:art=$tierart]) &lt; 2)">
				In dieser Unterkunft gibt es kein Paar dieser Art (<value-of select="arc:art"/>).</assert>
		</rule>
	</pattern>
	<diagnostics>
		<diagnostic id="Anzahl">Noah, du hast <value-of 
			select="count(parent::*/arc:tier[arc:art=$tierart])"/> Tiere von der Gattung <value-of select="arc:art"/>.</diagnostic>
	</diagnostics>
</schema>