<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
	<ns prefix="html" uri="http://www.w3.org/1999/xhtml"/>
	<pattern>
		<!--
			Die folgende Regel prüft, ob die erste Überschrift des Dokuments als
			h1 getaggt wurde.
		-->
		<rule context="html:body">
			<let name="firstDescendantHeading" value="descendant::node()[name()=('h1','h2','h3','h4','h5','h6')][1]"/>
			<assert test="$firstDescendantHeading/self::html:h1">
				Die erste Überschrift in einem Dokument muss h1 sein.
			</assert>
		</rule>
		<!--
			Die Grundüberlegung: h1- und h2-Elemente können niemals eine Überschriftenebene übersprungen haben. Erst ab der dritten Hierarchiestufe kann dieser Fall eintreten. Die erste Regel Überprüft dementsprechend alle h3-Elemente darauf, ob die nächst vorangegangene Überschrift eine h1 ist (denn alle anderen Überschrift-Typen können richtig sein).
		-->
		<rule context="html:h3">
			<let name="firstPrecedingHeading" value="preceding::node()[name()=('h1','h2','h3','h4','h5','h6')][1]"/>
			<report test="$firstPrecedingHeading/self::html:h1" diagnostics="HierarchyCrashLevel1">Eine Überschriftenebene wurde ausgelassen: Eine h3 darf nicht auf eine <value-of select="$firstPrecedingHeading/name()"/> folgen.</report>
		</rule>
		<!-- 
			Die nächste Regel geht analog zur vorherigen vor. Sie überprüft alle h4-Elemente auf zwei Bedingungen.
			Erstens: Die nächst vorangegangene Überschrift darf keine h1 sein.
			Zweitens: Die nächst vorangegangene Überschrift darf auch keine h2 sein.
			Mit Hilfe der Diagnostics bekommt der Benutzer eine konkrete Handlungsanweisung, um das Problem zu lösen. Ihm wird in diesem Fall vorgeschlagen, das fehlerhafte Tag zu ändern, sodass die Hierarchie wieder stimmt.
		-->
		<rule context="html:h4">
			<let name="firstPrecedingHeading" value="preceding::node()[name()=('h1','h2','h3','h4','h5','h6')][1]"/>
			<report test="$firstPrecedingHeading/self::html:h1" diagnostics="HierarchyCrashLevel1">Zwei Überschriftenebenen wurden ausgelassen: Eine h4 darf nicht auf eine <value-of select="$firstPrecedingHeading/name()"/> folgen.</report>
			<report test="$firstPrecedingHeading/self::html:h2" diagnostics="HierarchyCrashLevel2">Eine Überschriftenebene wurde ausgelassen: Eine h4 darf nicht auf eine <value-of select="$firstPrecedingHeading/name()"/> folgen.</report>
		</rule>
	</pattern>
	<diagnostics>
		<diagnostic id="HierarchyCrashLevel1"> Ändern Sie das Element für die Überschrift '<value-of select="."/>' in h2, um einen Unterabschnitt von '<value-of select="$firstPrecedingHeading"/>' einzuleiten! </diagnostic>
		<diagnostic id="HierarchyCrashLevel2"> Ändern Sie das Element für die Überschrift '<value-of select="."/>' in h3, um einen Unterabschnitt von '<value-of select="$firstPrecedingHeading"/>' einzuleiten!</diagnostic>
	</diagnostics>
</schema>
