<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
	<pattern id="kundenpreis">
		<rule context="kunde/preis">
			<let name="kundeId" value="parent::kunde/kundeId"/>
			<assert test="sum(//produkt[kundeId=$kundeId]/preis)=.">Die Summe stimmt an dieser Stelle nicht. Sie müsste <value-of 
				select="sum(//produkt[kundeId=$kundeId]/preis)"/> lauten.</assert>
		</rule>
	</pattern>
	<pattern id="angebotspreis">
		<rule context="angebot/preis">
			<assert test="sum(//kunde/preis)=.">Die Summe stimmt an dieser Stelle nicht. Sie müsste <value-of select="sum(//kunde/preis)"/> lauten.</assert>
		</rule>
	</pattern>
	<pattern id="verbindungProdukt">
		<rule context="kunde">
			<let name="missings" value="//produkt[kundeId = current()/kundeId]/produktId[not(.=current()/produktId)]"/>
			<report test="count($missings)>0">Hier fehlt/en die Produkt-ID(s): <value-of select="string-join($missings, ', ')"/>.</report>
		</rule>
	</pattern>
</schema>
