<schema xmlns:html="http://www.w3.org/1999/xhtml" xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" queryBinding="xslt2">
	<ns prefix="d2t" uri="http://www.data2type.de/html"/>
	<ns prefix="html" uri="http://www.w3.org/1999/xhtml"/>
	<xsl:function name="d2t:getColAndRows">
		<xsl:param name="preCells"/>
		<xsl:param name="cells"/>
		<xsl:variable name="cellsWithRows">
			<xsl:choose>
				<!-- 
					wird zur Initialisierung beim 
					ersten Aufruf der Funktion verwendet:
				-->
				<xsl:when test="$cells[not(@d2t:rowNumber)] | 
					$cells[not(@colspan|@rowspan)]">
					<xsl:for-each select="$cells">
						<xsl:copy>
							<xsl:attribute name="d2t:rowNumber" select="count(../preceding-sibling::html:tr | 
								../parent::*[not(self::html:table)]/preceding-sibling::*/html:tr
								) + 1"/>
							<xsl:attribute name="colspan" select="'1'"/>
							<xsl:attribute name="rowspan" select="'1'"/>
							<xsl:attribute name="d2t:tableID" select="generate-id(./ancestor::html:table[1])"/>
							<xsl:attribute name="d2t:cellID" select="generate-id()"/>
							<xsl:copy-of select="@*"/>
							<xsl:apply-templates/>
						</xsl:copy>
					</xsl:for-each>
				</xsl:when>
				<!-- für alle rekursiven Aufrufe: -->
				<xsl:otherwise>
					<xsl:copy-of select="$cells"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="cells" select="$cellsWithRows//html:td"/>
		<xsl:choose>
			<xsl:when test="count($cells)=0">
				<xsl:copy-of select="$preCells"/>
				<xsl:copy-of select="$cells"/>
			</xsl:when>
			<!-- falls nur die erste Zelle der Tabelle übergeben wird: -->
			<xsl:when test="count($cells)=1 and count($preCells)=0">
				<html:td>
					<xsl:attribute name="d2t:colNumber">1</xsl:attribute>
					<xsl:copy-of select="$cells/@*"/>
					<xsl:copy-of select="$cells/node()"/>
				</html:td>
			</xsl:when>
			<xsl:otherwise>
				<!-- 
					rekursive Aufrufe jeweils mit der ersten und zweiten Hälfte 
					der <td>-Elemente 
				-->
				<xsl:variable name="half" select="count($cells) div 2"/>
				<xsl:variable name="firstHalf" select="d2t:getColAndRows($preCells, $cells[position() &lt; $half])"/>
				<xsl:variable name="secondHalf" select="d2t:getColAndRows(($firstHalf),
					$cells	[position() &gt;= $half]
					[not(position()=last())])"/>
				<xsl:variable name="cell" select="$cells[last()]"/>
				<xsl:variable name="preCells" select="($secondHalf)"/>
				<xsl:variable name="preCell" select="$preCells[last()]"/>
				<!--  vorläufige Spaltennummer: -->
				<xsl:variable name="colOhneRowspan" select="if (($preCell/@d2t:rowNumber) &lt; ($cell/@d2t:rowNumber)) 
					then (1) 
					else (($preCell/@d2t:colNumber) + ($preCell/@colspan))"/>
				<!-- endgültige Spaltennummer: -->
				<xsl:variable name="colMitRowspan" select="d2t:getCol($colOhneRowspan,
					$cell/@d2t:rowNumber,
					$preCells[(@rowspan) &gt; 1])"/>
				<!-- Ausgabe der Zellen: -->
				<xsl:copy-of select="$preCells"/>
				<html:td>
					<xsl:attribute name="d2t:colNumber" select="$colMitRowspan"/>
					<xsl:copy-of select="$cell/@*"/>
					<xsl:copy-of select="$cell/node()"/>
				</html:td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="d2t:getColAndRows">
		<xsl:param name="cells"/>
		<xsl:copy-of select="d2t:getColAndRows((),$cells)"/>
	</xsl:function>
	<xsl:function name="d2t:getCol">
		<xsl:param name="curCol"/>
		<xsl:param name="curRow" as="xs:integer"/>
		<xsl:param name="preCells"/>
		<xsl:choose>
			<!-- 
				rekursiver Aufruf, falls eine zeilenüberspannende Zelle die Zeile $curRow in der Spalte $curCol überspannt -->
			<xsl:when test="$preCells [(@d2t:colNumber) &lt;= $curCol 
				and
				$curCol &lt; @d2t:colNumber + @colspan]
				[@d2t:rowNumber + @rowspan &gt; $curRow]">
				<xsl:value-of select="d2t:getCol($curCol + 1, $curRow, $preCells)"/>
			</xsl:when>
			<!-- Ausgabe der $curRow als endgültige Spaltennummer -->
			<xsl:otherwise>
				<xsl:value-of select="$curCol"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<let name="cells" value="for $table in //html:table 
		return d2t:getColAndRows($table//html:td)"/>
	<pattern>
		<rule context="html:td[(@colspan) &gt; 1]">
			<let name="tableID" value="generate-id(./ancestor::html:table[1])"/>
			<let name="cellID" value="generate-id()"/>
			<!-- alle Zellen dieser Tabelle:-->
			<let name="cells" value="$cells[@d2t:tableID=$tableID]"/>
			<let name="rowNumber" value="count(	../preceding-sibling::html:tr | 
				../parent::*[not(self::html:table)]/preceding-sibling::*/html:tr)+1"/>
			<!-- akutelle Zelle mit ermittelter Spaltennummer:-->
			<let name="cell" value="$cells[@d2t:cellID=$cellID]"/>
			<!-- ermittelt alle Zellen, die in dieser Zeile stehen 
				oder diese überspannen: -->
			<let name="row" value="$cells	[(@d2t:rowNumber) + (@rowspan) &gt; ($rowNumber)]
				[(@d2t:rowNumber) &lt;= ($rowNumber)]"/>
			<!-- Spaltennummern, in denen sich Zellen überschneiden: -->
			<let name="cross" value="$row[(@d2t:colNumber) &lt; ($cell/@d2t:colNumber) + ($cell/@colspan)]
				[(@d2t:colNumber) + (@colspan) &gt;= 
				$cell/@d2t:colNumber + $cell/@colspan]
				[not(@d2t:cellID=$cellID)]"/>
			<assert test="count($cross) = 0">Diese Zelle überschneidet sich mit der/n zeilenüberspannenden Zelle/n aus den Spalten <value-of select="for $x in $cross
				return 	if ($x = $cross[last()]) 
				then ($x/@d2t:colNumber) 
				else (concat($x/@d2t:colNumber, ','))"/>.</assert>
			
		</rule>
		<rule context="html:tr">
			<let name="tableID" value="generate-id(./ancestor::html:table[1])"/>
			<!-- alle Zellen dieser Tabelle:-->
			<let name="cells" value="$cells[@d2t:tableID=$tableID]"/>
			<!-- äußerste gefüllte Spalte: -->
			<let name="maxCol" value="xs:integer(max(
				for $cell in $cells 
				return ($cell/@d2t:colNumber + $cell/@colspan - 1)))"/>
			<let name="rowNumber" value="count(preceding-sibling::html:tr | parent::*[not(self::html:table)]/preceding-sibling::*/html:tr)+1"/>
			<!-- gibt für jede mögliche Spalte die Zellen aus, die in dieser Spalte und in der aktuellen Zeile stehen: -->
			<let name="row" value="for $i in (1 to ($maxCol))
				return ($cells[	(@d2t:colNumber) &lt;= $i 
				and
				$i &lt; (@d2t:colNumber) + (@colspan)]
				[(@d2t:rowNumber) + (@rowspan) &gt; ($rowNumber)]
				[(@d2t:rowNumber) &lt;= ($rowNumber)])"/>
			<!-- verlan&gt;e Anzahl an Spalten: -->
			<let name="forcedColCount" value="if (ancestor::html:table[1]//html:col) 
				then (count(ancestor::html:table[1]//html:col)) 
				else ($maxCol)"/>
			<assert test="count($row) &gt;= $forcedColCount">Es fehlen Zellen. (Anzahl fehlender Zellen: <value-of select="$forcedColCount - count($row)"/> von <value-of select="$forcedColCount"/>)</assert>
			<report test="count($row) &gt; $forcedColCount">Es gibt zu viele Zellen. (Anzahl überflüssiger Zellen: <value-of select="count($row) - $forcedColCount"/>)</report>
		</rule>
	</pattern>
</schema>
