<?xml version="1.0" encoding="UTF-8"?>
<p:declare-step xmlns:p="http://www.w3.org/ns/xproc" 
	xmlns:c="http://www.w3.org/ns/xproc-step" name="SchematronSchleife" version="1.0">
	<p:input port="source" sequence="true"/>
	<p:output port="result" sequence="true" primary="true"/>
	<p:directory-list include-filter=".*xml" path="input"/>
	<p:filter select="//c:file"/>
	<p:for-each>
		<p:variable name="filename" select="//c:file/@name"/>
		<p:make-absolute-uris match="c:file/@name"/>
		<p:load dtd-validate="false">
			<p:with-option name="href" select="//c:file/@name"/>
		</p:load>
		<p:documentation>http://www.w3.org/TR/xproc/#c.validate-with-schematron</p:documentation>
		<p:validate-with-schematron assert-valid="false" name="SchematronBeispiel">
			<p:input port="schema">
				<p:document href="arche.sch"/>
			</p:input>
			<p:input port="parameters">
				<p:empty/>
			</p:input>
		</p:validate-with-schematron>
		<p:identity>
			<p:input port="source">
				<p:pipe port="report" step="SchematronBeispiel"/>
			</p:input>
		</p:identity>
	</p:for-each>
</p:declare-step>